USE [Dynamic SQL Session];
GO

DECLARE @Login nvarchar(100)
DECLARE @Type nvarchar(100) = 'S'
DECLARE @is_disabled int = 1
DECLARE @default_database_name nvarchar(200)

SELECT principal_id AS SrvPrincipalId, name AS SrvPrincipal, type, type_desc,  
		is_disabled, default_database_name, default_language_name, sid 
FROM sys.server_principals Logins 
WHERE 
-- Can't use an index
	Logins.name = ISNULL(@Login,Logins.name) 
  AND Logins.type = ISNULL(@Type,Logins.type)
-- Can use indexes but not always as efficiently.
  AND (@default_database_name IS NULL 
			OR Logins.default_database_name = @default_database_name)
  AND (@is_disabled IS NULL 
			OR Logins.is_disabled = @is_disabled)	
GO
